<?php

namespace Microsoft\Graph\Generated\Users\Item\Authentication\PasswordMethods\Item;

use Microsoft\Kiota\Abstractions\QueryParameter;

/**
 * Represents the password registered to a user for authentication. For security, the password itself is never returned in the object, but action can be taken to reset a password.
*/
class PasswordAuthenticationMethodItemRequestBuilderGetQueryParameters 
{
    /**
     * @QueryParameter("%24expand")
     * @var array<string>|null $expand Expand related entities
    */
    public ?array $expand = null;
    
    /**
     * @QueryParameter("%24select")
     * @var array<string>|null $select Select properties to be returned
    */
    public ?array $select = null;
    
    /**
     * Instantiates a new PasswordAuthenticationMethodItemRequestBuilderGetQueryParameters and sets the default values.
     * @param array<string>|null $expand Expand related entities
     * @param array<string>|null $select Select properties to be returned
    */
    public function __construct(?array $expand = null, ?array $select = null) {
        $this->expand = $expand;
        $this->select = $select;
    }

}
