<?php

namespace Microsoft\Graph\Generated\Models;

use DateTime;
use Microsoft\Kiota\Abstractions\Serialization\Parsable;
use Microsoft\Kiota\Abstractions\Serialization\ParseNode;
use Microsoft\Kiota\Abstractions\Serialization\SerializationWriter;
use Microsoft\Kiota\Abstractions\Types\TypeUtils;

/**
 * Malware information entity.
*/
class WindowsMalwareInformation extends Entity implements Parsable 
{
    /**
     * Instantiates a new WindowsMalwareInformation and sets the default values.
    */
    public function __construct() {
        parent::__construct();
    }

    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param ParseNode $parseNode The parse node to use to read the discriminator value and create the object
     * @return WindowsMalwareInformation
    */
    public static function createFromDiscriminatorValue(ParseNode $parseNode): WindowsMalwareInformation {
        return new WindowsMalwareInformation();
    }

    /**
     * Gets the additionalInformationUrl property value. Indicates an informational URL to learn more about the malware
     * @return string|null
    */
    public function getAdditionalInformationUrl(): ?string {
        $val = $this->getBackingStore()->get('additionalInformationUrl');
        if (is_null($val) || is_string($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'additionalInformationUrl'");
    }

    /**
     * Gets the category property value. Category of the malware. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remoteControlSoftware, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule. default value is invalid. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remoteControlSoftware, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule.
     * @return WindowsMalwareCategory|null
    */
    public function getCategory(): ?WindowsMalwareCategory {
        $val = $this->getBackingStore()->get('category');
        if (is_null($val) || $val instanceof WindowsMalwareCategory) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'category'");
    }

    /**
     * Gets the deviceMalwareStates property value. List of devices affected by current malware with the malware state on each device
     * @return array<MalwareStateForWindowsDevice>|null
    */
    public function getDeviceMalwareStates(): ?array {
        $val = $this->getBackingStore()->get('deviceMalwareStates');
        if (is_array($val) || is_null($val)) {
            TypeUtils::validateCollectionValues($val, MalwareStateForWindowsDevice::class);
            /** @var array<MalwareStateForWindowsDevice>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'deviceMalwareStates'");
    }

    /**
     * Gets the displayName property value. Indicates the name of the malware
     * @return string|null
    */
    public function getDisplayName(): ?string {
        $val = $this->getBackingStore()->get('displayName');
        if (is_null($val) || is_string($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'displayName'");
    }

    /**
     * The deserialization information for the current model
     * @return array<string, callable(ParseNode): void>
    */
    public function getFieldDeserializers(): array {
        $o = $this;
        return array_merge(parent::getFieldDeserializers(), [
            'additionalInformationUrl' => fn(ParseNode $n) => $o->setAdditionalInformationUrl($n->getStringValue()),
            'category' => fn(ParseNode $n) => $o->setCategory($n->getEnumValue(WindowsMalwareCategory::class)),
            'deviceMalwareStates' => fn(ParseNode $n) => $o->setDeviceMalwareStates($n->getCollectionOfObjectValues([MalwareStateForWindowsDevice::class, 'createFromDiscriminatorValue'])),
            'displayName' => fn(ParseNode $n) => $o->setDisplayName($n->getStringValue()),
            'lastDetectionDateTime' => fn(ParseNode $n) => $o->setLastDetectionDateTime($n->getDateTimeValue()),
            'severity' => fn(ParseNode $n) => $o->setSeverity($n->getEnumValue(WindowsMalwareSeverity::class)),
        ]);
    }

    /**
     * Gets the lastDetectionDateTime property value. Indicates the last time the malware was detected in UTC
     * @return DateTime|null
    */
    public function getLastDetectionDateTime(): ?DateTime {
        $val = $this->getBackingStore()->get('lastDetectionDateTime');
        if (is_null($val) || $val instanceof DateTime) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'lastDetectionDateTime'");
    }

    /**
     * Gets the severity property value. Severity of the malware. Possible values are: unknown, low, moderate, high, severe. default is unknown. Possible values are: unknown, low, moderate, high, severe.
     * @return WindowsMalwareSeverity|null
    */
    public function getSeverity(): ?WindowsMalwareSeverity {
        $val = $this->getBackingStore()->get('severity');
        if (is_null($val) || $val instanceof WindowsMalwareSeverity) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'severity'");
    }

    /**
     * Serializes information the current object
     * @param SerializationWriter $writer Serialization writer to use to serialize this model
    */
    public function serialize(SerializationWriter $writer): void {
        parent::serialize($writer);
        $writer->writeStringValue('additionalInformationUrl', $this->getAdditionalInformationUrl());
        $writer->writeEnumValue('category', $this->getCategory());
        $writer->writeCollectionOfObjectValues('deviceMalwareStates', $this->getDeviceMalwareStates());
        $writer->writeStringValue('displayName', $this->getDisplayName());
        $writer->writeDateTimeValue('lastDetectionDateTime', $this->getLastDetectionDateTime());
        $writer->writeEnumValue('severity', $this->getSeverity());
    }

    /**
     * Sets the additionalInformationUrl property value. Indicates an informational URL to learn more about the malware
     * @param string|null $value Value to set for the additionalInformationUrl property.
    */
    public function setAdditionalInformationUrl(?string $value): void {
        $this->getBackingStore()->set('additionalInformationUrl', $value);
    }

    /**
     * Sets the category property value. Category of the malware. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remoteControlSoftware, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule. default value is invalid. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remoteControlSoftware, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule.
     * @param WindowsMalwareCategory|null $value Value to set for the category property.
    */
    public function setCategory(?WindowsMalwareCategory $value): void {
        $this->getBackingStore()->set('category', $value);
    }

    /**
     * Sets the deviceMalwareStates property value. List of devices affected by current malware with the malware state on each device
     * @param array<MalwareStateForWindowsDevice>|null $value Value to set for the deviceMalwareStates property.
    */
    public function setDeviceMalwareStates(?array $value): void {
        $this->getBackingStore()->set('deviceMalwareStates', $value);
    }

    /**
     * Sets the displayName property value. Indicates the name of the malware
     * @param string|null $value Value to set for the displayName property.
    */
    public function setDisplayName(?string $value): void {
        $this->getBackingStore()->set('displayName', $value);
    }

    /**
     * Sets the lastDetectionDateTime property value. Indicates the last time the malware was detected in UTC
     * @param DateTime|null $value Value to set for the lastDetectionDateTime property.
    */
    public function setLastDetectionDateTime(?DateTime $value): void {
        $this->getBackingStore()->set('lastDetectionDateTime', $value);
    }

    /**
     * Sets the severity property value. Severity of the malware. Possible values are: unknown, low, moderate, high, severe. default is unknown. Possible values are: unknown, low, moderate, high, severe.
     * @param WindowsMalwareSeverity|null $value Value to set for the severity property.
    */
    public function setSeverity(?WindowsMalwareSeverity $value): void {
        $this->getBackingStore()->set('severity', $value);
    }

}
