<?php

namespace Microsoft\Graph\Generated\Models;

use DateTime;
use Microsoft\Kiota\Abstractions\Serialization\Parsable;
use Microsoft\Kiota\Abstractions\Serialization\ParseNode;
use Microsoft\Kiota\Abstractions\Serialization\SerializationWriter;

/**
 * Malware state for a windows device
*/
class MalwareStateForWindowsDevice extends Entity implements Parsable 
{
    /**
     * Instantiates a new MalwareStateForWindowsDevice and sets the default values.
    */
    public function __construct() {
        parent::__construct();
    }

    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param ParseNode $parseNode The parse node to use to read the discriminator value and create the object
     * @return MalwareStateForWindowsDevice
    */
    public static function createFromDiscriminatorValue(ParseNode $parseNode): MalwareStateForWindowsDevice {
        return new MalwareStateForWindowsDevice();
    }

    /**
     * Gets the detectionCount property value. Indicates the number of times the malware is detected
     * @return int|null
    */
    public function getDetectionCount(): ?int {
        $val = $this->getBackingStore()->get('detectionCount');
        if (is_null($val) || is_int($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'detectionCount'");
    }

    /**
     * Gets the deviceName property value. Indicates the name of the device being evaluated for malware state
     * @return string|null
    */
    public function getDeviceName(): ?string {
        $val = $this->getBackingStore()->get('deviceName');
        if (is_null($val) || is_string($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'deviceName'");
    }

    /**
     * Gets the executionState property value. Indicates execution status of the malware. Possible values are: unknown, blocked, allowed, running, notRunning. Defaults to unknown. Possible values are: unknown, blocked, allowed, running, notRunning.
     * @return WindowsMalwareExecutionState|null
    */
    public function getExecutionState(): ?WindowsMalwareExecutionState {
        $val = $this->getBackingStore()->get('executionState');
        if (is_null($val) || $val instanceof WindowsMalwareExecutionState) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'executionState'");
    }

    /**
     * The deserialization information for the current model
     * @return array<string, callable(ParseNode): void>
    */
    public function getFieldDeserializers(): array {
        $o = $this;
        return array_merge(parent::getFieldDeserializers(), [
            'detectionCount' => fn(ParseNode $n) => $o->setDetectionCount($n->getIntegerValue()),
            'deviceName' => fn(ParseNode $n) => $o->setDeviceName($n->getStringValue()),
            'executionState' => fn(ParseNode $n) => $o->setExecutionState($n->getEnumValue(WindowsMalwareExecutionState::class)),
            'initialDetectionDateTime' => fn(ParseNode $n) => $o->setInitialDetectionDateTime($n->getDateTimeValue()),
            'lastStateChangeDateTime' => fn(ParseNode $n) => $o->setLastStateChangeDateTime($n->getDateTimeValue()),
            'threatState' => fn(ParseNode $n) => $o->setThreatState($n->getEnumValue(WindowsMalwareThreatState::class)),
        ]);
    }

    /**
     * Gets the initialDetectionDateTime property value. Initial detection datetime of the malware
     * @return DateTime|null
    */
    public function getInitialDetectionDateTime(): ?DateTime {
        $val = $this->getBackingStore()->get('initialDetectionDateTime');
        if (is_null($val) || $val instanceof DateTime) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'initialDetectionDateTime'");
    }

    /**
     * Gets the lastStateChangeDateTime property value. The last time this particular threat was changed
     * @return DateTime|null
    */
    public function getLastStateChangeDateTime(): ?DateTime {
        $val = $this->getBackingStore()->get('lastStateChangeDateTime');
        if (is_null($val) || $val instanceof DateTime) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'lastStateChangeDateTime'");
    }

    /**
     * Gets the threatState property value. Indicates threat status of the malware. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared. defaults to noStatusCleared. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared.
     * @return WindowsMalwareThreatState|null
    */
    public function getThreatState(): ?WindowsMalwareThreatState {
        $val = $this->getBackingStore()->get('threatState');
        if (is_null($val) || $val instanceof WindowsMalwareThreatState) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'threatState'");
    }

    /**
     * Serializes information the current object
     * @param SerializationWriter $writer Serialization writer to use to serialize this model
    */
    public function serialize(SerializationWriter $writer): void {
        parent::serialize($writer);
        $writer->writeIntegerValue('detectionCount', $this->getDetectionCount());
        $writer->writeStringValue('deviceName', $this->getDeviceName());
        $writer->writeEnumValue('executionState', $this->getExecutionState());
        $writer->writeDateTimeValue('initialDetectionDateTime', $this->getInitialDetectionDateTime());
        $writer->writeDateTimeValue('lastStateChangeDateTime', $this->getLastStateChangeDateTime());
        $writer->writeEnumValue('threatState', $this->getThreatState());
    }

    /**
     * Sets the detectionCount property value. Indicates the number of times the malware is detected
     * @param int|null $value Value to set for the detectionCount property.
    */
    public function setDetectionCount(?int $value): void {
        $this->getBackingStore()->set('detectionCount', $value);
    }

    /**
     * Sets the deviceName property value. Indicates the name of the device being evaluated for malware state
     * @param string|null $value Value to set for the deviceName property.
    */
    public function setDeviceName(?string $value): void {
        $this->getBackingStore()->set('deviceName', $value);
    }

    /**
     * Sets the executionState property value. Indicates execution status of the malware. Possible values are: unknown, blocked, allowed, running, notRunning. Defaults to unknown. Possible values are: unknown, blocked, allowed, running, notRunning.
     * @param WindowsMalwareExecutionState|null $value Value to set for the executionState property.
    */
    public function setExecutionState(?WindowsMalwareExecutionState $value): void {
        $this->getBackingStore()->set('executionState', $value);
    }

    /**
     * Sets the initialDetectionDateTime property value. Initial detection datetime of the malware
     * @param DateTime|null $value Value to set for the initialDetectionDateTime property.
    */
    public function setInitialDetectionDateTime(?DateTime $value): void {
        $this->getBackingStore()->set('initialDetectionDateTime', $value);
    }

    /**
     * Sets the lastStateChangeDateTime property value. The last time this particular threat was changed
     * @param DateTime|null $value Value to set for the lastStateChangeDateTime property.
    */
    public function setLastStateChangeDateTime(?DateTime $value): void {
        $this->getBackingStore()->set('lastStateChangeDateTime', $value);
    }

    /**
     * Sets the threatState property value. Indicates threat status of the malware. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared. defaults to noStatusCleared. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared.
     * @param WindowsMalwareThreatState|null $value Value to set for the threatState property.
    */
    public function setThreatState(?WindowsMalwareThreatState $value): void {
        $this->getBackingStore()->set('threatState', $value);
    }

}
