<?php

namespace Microsoft\Graph\Generated\Models;

use Microsoft\Kiota\Abstractions\Serialization\AdditionalDataHolder;
use Microsoft\Kiota\Abstractions\Serialization\Parsable;
use Microsoft\Kiota\Abstractions\Serialization\ParseNode;
use Microsoft\Kiota\Abstractions\Serialization\SerializationWriter;
use Microsoft\Kiota\Abstractions\Store\BackedModel;
use Microsoft\Kiota\Abstractions\Store\BackingStore;
use Microsoft\Kiota\Abstractions\Store\BackingStoreFactorySingleton;

/**
 * Specify Defender’s actions to take on detected Malware per threat level.
*/
class DefenderDetectedMalwareActions implements AdditionalDataHolder, BackedModel, Parsable 
{
    /**
     * @var BackingStore $backingStore Stores model information.
    */
    private BackingStore $backingStore;
    
    /**
     * Instantiates a new DefenderDetectedMalwareActions and sets the default values.
    */
    public function __construct() {
        $this->backingStore = BackingStoreFactorySingleton::getInstance()->createBackingStore();
        $this->setAdditionalData([]);
    }

    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param ParseNode $parseNode The parse node to use to read the discriminator value and create the object
     * @return DefenderDetectedMalwareActions
    */
    public static function createFromDiscriminatorValue(ParseNode $parseNode): DefenderDetectedMalwareActions {
        return new DefenderDetectedMalwareActions();
    }

    /**
     * Gets the AdditionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
     * @return array<string, mixed>|null
    */
    public function getAdditionalData(): ?array {
        $val = $this->getBackingStore()->get('additionalData');
        if (is_null($val) || is_array($val)) {
            /** @var array<string, mixed>|null $val */
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'additionalData'");
    }

    /**
     * Gets the BackingStore property value. Stores model information.
     * @return BackingStore
    */
    public function getBackingStore(): BackingStore {
        return $this->backingStore;
    }

    /**
     * The deserialization information for the current model
     * @return array<string, callable(ParseNode): void>
    */
    public function getFieldDeserializers(): array {
        $o = $this;
        return  [
            'highSeverity' => fn(ParseNode $n) => $o->setHighSeverity($n->getEnumValue(DefenderThreatAction::class)),
            'lowSeverity' => fn(ParseNode $n) => $o->setLowSeverity($n->getEnumValue(DefenderThreatAction::class)),
            'moderateSeverity' => fn(ParseNode $n) => $o->setModerateSeverity($n->getEnumValue(DefenderThreatAction::class)),
            '@odata.type' => fn(ParseNode $n) => $o->setOdataType($n->getStringValue()),
            'severeSeverity' => fn(ParseNode $n) => $o->setSevereSeverity($n->getEnumValue(DefenderThreatAction::class)),
        ];
    }

    /**
     * Gets the highSeverity property value. Defender’s default action to take on detected Malware threats.
     * @return DefenderThreatAction|null
    */
    public function getHighSeverity(): ?DefenderThreatAction {
        $val = $this->getBackingStore()->get('highSeverity');
        if (is_null($val) || $val instanceof DefenderThreatAction) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'highSeverity'");
    }

    /**
     * Gets the lowSeverity property value. Defender’s default action to take on detected Malware threats.
     * @return DefenderThreatAction|null
    */
    public function getLowSeverity(): ?DefenderThreatAction {
        $val = $this->getBackingStore()->get('lowSeverity');
        if (is_null($val) || $val instanceof DefenderThreatAction) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'lowSeverity'");
    }

    /**
     * Gets the moderateSeverity property value. Defender’s default action to take on detected Malware threats.
     * @return DefenderThreatAction|null
    */
    public function getModerateSeverity(): ?DefenderThreatAction {
        $val = $this->getBackingStore()->get('moderateSeverity');
        if (is_null($val) || $val instanceof DefenderThreatAction) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'moderateSeverity'");
    }

    /**
     * Gets the @odata.type property value. The OdataType property
     * @return string|null
    */
    public function getOdataType(): ?string {
        $val = $this->getBackingStore()->get('odataType');
        if (is_null($val) || is_string($val)) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'odataType'");
    }

    /**
     * Gets the severeSeverity property value. Defender’s default action to take on detected Malware threats.
     * @return DefenderThreatAction|null
    */
    public function getSevereSeverity(): ?DefenderThreatAction {
        $val = $this->getBackingStore()->get('severeSeverity');
        if (is_null($val) || $val instanceof DefenderThreatAction) {
            return $val;
        }
        throw new \UnexpectedValueException("Invalid type found in backing store for 'severeSeverity'");
    }

    /**
     * Serializes information the current object
     * @param SerializationWriter $writer Serialization writer to use to serialize this model
    */
    public function serialize(SerializationWriter $writer): void {
        $writer->writeEnumValue('highSeverity', $this->getHighSeverity());
        $writer->writeEnumValue('lowSeverity', $this->getLowSeverity());
        $writer->writeEnumValue('moderateSeverity', $this->getModerateSeverity());
        $writer->writeStringValue('@odata.type', $this->getOdataType());
        $writer->writeEnumValue('severeSeverity', $this->getSevereSeverity());
        $writer->writeAdditionalData($this->getAdditionalData());
    }

    /**
     * Sets the AdditionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
     * @param array<string,mixed> $value Value to set for the AdditionalData property.
    */
    public function setAdditionalData(?array $value): void {
        $this->getBackingStore()->set('additionalData', $value);
    }

    /**
     * Sets the BackingStore property value. Stores model information.
     * @param BackingStore $value Value to set for the BackingStore property.
    */
    public function setBackingStore(BackingStore $value): void {
        $this->backingStore = $value;
    }

    /**
     * Sets the highSeverity property value. Defender’s default action to take on detected Malware threats.
     * @param DefenderThreatAction|null $value Value to set for the highSeverity property.
    */
    public function setHighSeverity(?DefenderThreatAction $value): void {
        $this->getBackingStore()->set('highSeverity', $value);
    }

    /**
     * Sets the lowSeverity property value. Defender’s default action to take on detected Malware threats.
     * @param DefenderThreatAction|null $value Value to set for the lowSeverity property.
    */
    public function setLowSeverity(?DefenderThreatAction $value): void {
        $this->getBackingStore()->set('lowSeverity', $value);
    }

    /**
     * Sets the moderateSeverity property value. Defender’s default action to take on detected Malware threats.
     * @param DefenderThreatAction|null $value Value to set for the moderateSeverity property.
    */
    public function setModerateSeverity(?DefenderThreatAction $value): void {
        $this->getBackingStore()->set('moderateSeverity', $value);
    }

    /**
     * Sets the @odata.type property value. The OdataType property
     * @param string|null $value Value to set for the @odata.type property.
    */
    public function setOdataType(?string $value): void {
        $this->getBackingStore()->set('odataType', $value);
    }

    /**
     * Sets the severeSeverity property value. Defender’s default action to take on detected Malware threats.
     * @param DefenderThreatAction|null $value Value to set for the severeSeverity property.
    */
    public function setSevereSeverity(?DefenderThreatAction $value): void {
        $this->getBackingStore()->set('severeSeverity', $value);
    }

}
