<?php

require_once('Language.php');
require_once('en_gb.php');

class du_nl extends en_gb
{
    public function __construct()
    {
        parent::__construct();
    }

    protected function _LoadStrings()
    {
        $strings = parent::_LoadStrings();

        $strings['FirstName'] = 'Voornaam';
        $strings['LastName'] = 'Achternaam';
        $strings['Timezone'] = 'Tijdzone';
        $strings['Edit'] = 'Bewerken';
        $strings['Change'] = 'Wijzig';
        $strings['Rename'] = 'Hernoem';
        $strings['Remove'] = 'Verwijder';
        $strings['Delete'] = 'Verwijderen';
        $strings['Update'] = 'Pas aan';
        $strings['Cancel'] = 'Annuleer';
        $strings['Add'] = 'Voeg toe';
        $strings['Name'] = 'Naam';
        $strings['Yes'] = 'Ja';
        $strings['No'] = 'Nee';
        $strings['FirstNameRequired'] = 'Voornaam is vereist.';
        $strings['LastNameRequired'] = 'Achternaam is vereist.';
        $strings['PwMustMatch'] = 'Wachtwoord bevestiging moet overeenkomen met het wachtwoord.';
        $strings['PwComplexity'] = 'Wachtwoord moet minstens 6 karakters lang zijn en bestaan uit een combinatie van alfanumerische tekens en symbolen';
        $strings['ValidEmailRequired'] = 'Een geldig email adres moet opgegeven worden.';
        $strings['UniqueEmailRequired'] = 'Dit email adres is al geregistreerd.';
        $strings['UniqueUsernameRequired'] = 'Deze gebruikersnaam is al geregistreerd.';
        $strings['UserNameRequired'] = 'Een gebruikersnaam is vereist.';
        $strings['CaptchaMustMatch'] = 'Voer exact de letters in zoals afgebeeld op de figuur.';
        $strings['Today'] = 'Vandaag';
        $strings['Week'] = 'Week';
        $strings['Month'] = 'Maand';
        $strings['BackToCalendar'] = 'Terug naar kalender';
        $strings['BeginDate'] = 'Begin';
        $strings['EndDate'] = 'Einde';
        $strings['Username'] = 'Gebruikersnaam';
        $strings['Password'] = 'Wachtwoord';
        $strings['PasswordConfirmation'] = 'Bevestig wachtwoord';
        $strings['DefaultPage'] = 'Standaard hoofdpagina';
        $strings['MyCalendar'] = 'Mijn kalender';
        $strings['ScheduleCalendar'] = 'Planning kalender';
        $strings['Registration'] = 'Registratie';
        $strings['NoAnnouncements'] = 'Er zijn geen mededelignen';
        $strings['Announcements'] = 'Mededelingen';
        $strings['NoUpcomingReservations'] = 'Je hebt geen aankomende reserveringen';
        $strings['UpcomingReservations'] = 'Aankomende reserveringen';
        $strings['AllNoUpcomingReservations'] = 'Er zijn geen aankomende reserveringen voor de komende %s dagen';
		$strings['AllUpcomingReservations'] = 'Alle aankomende reserveringen';
        $strings['ShowHide'] = 'Toon/Verberg';
        $strings['Error'] = 'Fout';
        $strings['ReturnToPreviousPage'] = 'Keer terug naar de pagina die u laatst bezocht';
        $strings['UnknownError'] = 'Onbekende fout';
        $strings['InsufficientPermissionsError'] = 'U hebt onvoldoende rechten tot deze bron';
        $strings['MissingReservationResourceError'] = 'Er werd geen bron geselecteerd';
        $strings['MissingReservationScheduleError'] = 'Er werd geen planning geselecteerd';
        $strings['DoesNotRepeat'] = 'Niet herhalen';
        $strings['Daily'] = 'Dagelijks';
        $strings['Weekly'] = 'Wekelijks';
        $strings['Monthly'] = 'Maandelijks';
        $strings['Yearly'] = 'Jaarlijks';
        $strings['RepeatPrompt'] = 'Herhaal';
        $strings['hours'] = 'uren';
        $strings['days'] = 'dagen';
        $strings['weeks'] = 'weken';
        $strings['months'] = 'maanden';
        $strings['years'] = 'jaren';
        $strings['day'] = 'dag';
        $strings['week'] = 'week';
        $strings['month'] = 'maand';
        $strings['year'] = 'jaar';
        $strings['repeatDayOfMonth'] = 'dag van de maand';
        $strings['repeatDayOfWeek'] = 'dag van de week';
        $strings['RepeatUntilPrompt'] = 'Tot';
        $strings['RepeatEveryPrompt'] = 'Elke';
        $strings['RepeatDaysPrompt'] = 'Op';
        $strings['CreateReservationHeading'] = 'Maak een nieuwe reservering';
        $strings['EditReservationHeading'] = 'Wijzig reservering %s';
        $strings['ViewReservationHeading'] = 'Raadpleeg reservering %s';
        $strings['ReservationErrors'] = 'Wijzig reservering';
        $strings['Create'] = 'Maak aan';
        $strings['ThisInstance'] = 'Enkel deze instantie';
        $strings['AllInstances'] = 'Alle instanties';
        $strings['FutureInstances'] = 'Toekomstige instanties';
        $strings['Print'] = 'Print';
        $strings['ShowHideNavigation'] = 'Toon/Verberg navigatie';
        $strings['ReferenceNumber'] = 'Referentie nummer';
        $strings['Tomorrow'] = 'Morgen';
        $strings['LaterThisWeek'] = 'Later deze week';
        $strings['NextWeek'] = 'Volgende week';
        $strings['SignOut'] = 'Uitloggen';
        $strings['LayoutDescription'] = 'Begint op %s, met %s zichtbare dagen';
        $strings['AllResources'] = 'Alle bronnen';
        $strings['TakeOffline'] = 'Breng offline';
        $strings['BringOnline'] = 'Breng online';
        $strings['AddImage'] = 'Voeg afbeelding toe';
        $strings['NoImage'] = 'Geen afbeelding gekoppeld';
        $strings['Move'] = 'Verplaats';
        $strings['AppearsOn'] = 'Verschijnt op %s';
        $strings['Location'] = 'Locatie';
        $strings['NoLocationLabel'] = '(geen locatie vermeld)';
        $strings['Contact'] = 'Contact';
        $strings['NoContactLabel'] = '(geen contact informatie)';
        $strings['Description'] = 'Beschrijving';
        $strings['NoDescriptionLabel'] = '(geen beschrijving)';
        $strings['Notes'] = 'Notities';
        $strings['NoNotesLabel'] = '(geen notities)';
        $strings['NoTitleLabel'] = '(geen titel)';
        $strings['UsageConfiguration'] = 'Gebruik configuratie';
        $strings['ChangeConfiguration'] = 'Wijzig configuratie';
        $strings['ResourceMinLength'] = 'Een reservering moet minimum %s duren';
        $strings['ResourceMinLengthNone'] = 'Er is geen minimale reserveringsduur';
        $strings['ResourceMaxLength'] = 'Reserveringen kunnen niet langer duren dan %s';
        $strings['ResourceMaxLengthNone'] = 'Er is geen maximale reserveringsduur';
        $strings['ResourceRequiresApproval'] = 'Reserveringen vereisen goedkeuring';
        $strings['ResourceRequiresApprovalNone'] = 'Reserveringen zonder goedkeuring';
        $strings['ResourcePermissionAutoGranted'] = 'Toegang wordt automatisch verleend';
        $strings['ResourcePermissionNotAutoGranted'] = 'Toegang wordt niet automatisch verleend';
        $strings['ResourceMinNotice'] = 'Reserveringen moeten minstens %s op voorhand gemaakt worden';
        $strings['ResourceMinNoticeNone'] = 'Reserveringen kunnen gemaakt worden vanaf huidig tijdstip';
        $strings['ResourceMinNoticeUpdate'] = 'Reserveringen moeten tenminste %s geupdate worden voorafgaand aan de start tijd';
		$strings['ResourceMinNoticeNoneUpdate'] = 'Reserveringen kunnen worden aangepast tot aan het huidige tijdstip';
		$strings['ResourceMinNoticeDelete'] = 'Reserveringen kunnen tot tenminste %s voorafgaand aan de start tijd verwijderd worden';
		$strings['ResourceMinNoticeNoneDelete'] = 'Reserveringen kunnen worden verwijderd tot aan het huidige tijdstip';
        $strings['ResourceMaxNotice'] = 'Reserveringen kunnen niet later eindigen dan %s van het huidige tijdstip';
        $strings['ResourceMaxNoticeNone'] = 'Reserveringen kunnen onbeperkt in de toekomst eindigen';
        $strings['ResourceBufferTime'] = 'Er moet %s zitten tussen reserveringen';
		$strings['ResourceBufferTimeNone'] = 'Reserveringen mogen elkaar direct opvolgen';
        $strings['ResourceAllowMultiDay'] = 'Meerdaagse reserveringen mogelijk';
        $strings['ResourceNotAllowMultiDay'] = 'Meerdaagse reserveringen niet toegelaten';
        $strings['ResourceCapacity'] = 'Deze bron heeft een capaciteit van %s personen';
        $strings['ResourceCapacityNone'] = 'Deze bron heeft ongelimiteerde capaciteit';
		$strings['AddNewResource'] = 'Nieuwe bron toevoegen';
        $strings['AddNewUser'] = 'Nieuwe gebruiker toevoegen';
        $strings['AddUser'] = 'Gebruiker toevoegen';
        $strings['Schedule'] = 'Planning';
        $strings['AddResource'] = 'Bron toevoegen';
        $strings['Capacity'] = 'Capaciteit';
        $strings['Access'] = 'Toegang';
        $strings['Duration'] = 'Duur';
        $strings['Active'] = 'Actief';
        $strings['Inactive'] = 'Inactief';
        $strings['ResetPassword'] = 'Reset wachtwoord';
        $strings['LastLogin'] = 'Laatst ingelogd';
        $strings['Search'] = 'Zoek';
        $strings['ResourcePermissions'] = 'Toegangsrechten bron';
        $strings['Reservations'] = 'Reserveringen';
        $strings['Groups'] = 'Groepen';
        $strings['Users'] = 'Gebruikers';
        $strings['ResetPassword'] = 'Reset wachtwoord';
        $strings['AllUsers'] = 'Alle gebruikers';
        $strings['AllGroups'] = 'Alle groepen';
        $strings['AllSchedules'] = 'Alle planningen';
        $strings['UsernameOrEmail'] = 'Gebruikersnaam of email';
        $strings['Members'] = 'Leden';
        $strings['QuickSlotCreation'] = 'Voeg slots toe elke %s minuten tussen %s en %s';
        $strings['ApplyUpdatesTo'] = 'Pas updates toe';
        $strings['CancelParticipation'] = 'Annuleer deelname';
        $strings['Attending'] = 'Wachtend...';
        $strings['QuotaConfiguration'] = 'Op %s voor %s gebruikers in %s zijn beperkt tot %s %s per %s';  
        $strings['QuotaEnforcement'] = 'Afgedwongen %s %s';
        $strings['reservations'] = 'reserveringen';
        $strings['reservation'] = 'reservering'; 
        $strings['ChangeCalendar'] = 'Wijzig kalender';
        $strings['AddQuota'] = 'Voeg kwota toe';
        $strings['FindUser'] = 'Zoek gebruiker';
        $strings['Created'] = 'Aangemaakt';
        $strings['LastModified'] = 'Laatste wijziging';
        $strings['GroupName'] = 'Groep naam';
        $strings['GroupMembers'] = 'Groep leden';
        $strings['GroupRoles'] = 'Groep rollen';
        $strings['GroupAdmin'] = 'Groep beheerder';
        $strings['Actions'] = 'Acties';
        $strings['CurrentPassword'] = 'Huidig wachtwoord';
        $strings['NewPassword'] = 'Nieuw wachtwoord';
        $strings['InvalidPassword'] = 'Huidig wachtwoord is fout';
        $strings['PasswordChangedSuccessfully'] = 'Uw wachtwoord is succesvol aangepast';
        $strings['SignedInAs'] = 'Ingelogd als';
        $strings['NotSignedIn'] = 'U bent niet ingelogd';
        $strings['ReservationTitle'] = 'Reservering titel';
        $strings['ReservationDescription'] = 'Beschrijving van de reservering';
        $strings['ResourceList'] = 'Te reserveren bronnen';
        $strings['Accessories'] = 'Accessoires';
        $strings['Add'] = 'Voeg toe';
        $strings['ParticipantList'] = 'Deelnemers';
        $strings['InvitationList'] = 'Uitgenodigden';
        $strings['AccessoryName'] = 'Naam accessoire';
        $strings['QuantityAvailable'] = 'Beschikbare hoeveelheid';
        $strings['Resources'] = 'Bronnen';
        $strings['Participants'] = 'Deelnemers';
        $strings['User'] = 'Gebruiker';
        $strings['Resource'] = 'Bron';
        $strings['Status'] = 'Status';
        $strings['Approve'] = 'Bevestig';
        $strings['Page'] = 'Pagina';
        $strings['Rows'] = 'Rijen';
        $strings['Unlimited'] = 'Onbeperkt';
        $strings['Email'] = 'Email';
        $strings['EmailAddress'] = 'Email adres';
        $strings['Phone'] = 'Telefoon';
        $strings['Organization'] = 'Organisatie';
        $strings['Position'] = 'Functie';
        $strings['Language'] = 'Taal';
        $strings['Permissions'] = 'Toegangsrechten';
        $strings['Reset'] = 'Reset';
        $strings['FindGroup'] = 'Groep zoeken';
        $strings['Manage'] = 'Beheer';
        $strings['None'] = 'Geen';
        $strings['AddToOutlook'] = 'Voeg toe in Outlook';
        $strings['Done'] = 'Klaar';
        $strings['RememberMe'] = 'Herinner me';
        $strings['FirstTimeUser?'] = 'Nieuwe gebruiker?';
        $strings['CreateAnAccount'] = 'Een account aanmaken';
        $strings['ViewSchedule'] = 'Bekijk planning';
        $strings['ForgotMyPassword'] = 'Wachtwoord vergeten';
        $strings['YouWillBeEmailedANewPassword'] = 'Je krijgt via de email een willekeurig gegenereerd wachtwoord toegestuurd';
        $strings['Close'] = 'Sluit';
        $strings['ExportToCSV'] = 'Exporteer naar CSV';
        $strings['OK'] = 'OK';
        $strings['Working'] = 'Bezig...';
        $strings['Login'] = 'Login';
        $strings['AdditionalInformation'] = 'Bijkomende informatie';
        $strings['AllFieldsAreRequired'] = 'alle velden zijn verplicht';
        $strings['Optional'] = 'optioneel';
        $strings['YourProfileWasUpdated'] = 'Je profiel is gewijzigd';
        $strings['YourSettingsWereUpdated'] = 'Je instellingen zijn gewijzigd';
        $strings['Register'] = 'Registreer';
        $strings['SecurityCode'] = 'Veiligheidscode';
        $strings['ReservationCreatedPreference'] = 'Wanneer ik of iemand in mijn naam een reservering maakt';
        $strings['ReservationUpdatedPreference'] = 'Wanneer ik of iemand anders een reservering van mij wijzigt';
        $strings['ReservationDeletedPreference'] = 'Wanneer ik of iemand anders een reservering van mij verwijderd';
        $strings['ReservationApprovalPreference'] = 'Wanneer mijn reserveringen uit de wachtrij zijn goedgekeurd';
        $strings['PreferenceSendEmail'] = 'Stuur me een email';
        $strings['PreferenceNoEmail'] = 'Geen melding sturen';
        $strings['ReservationCreated'] = 'Uw reservering is succesvol aangemaakt!';
        $strings['ReservationUpdated'] = 'Uw reservering is succesvol gewijzigd!';
        $strings['ReservationRemoved'] = 'Uw reservering is verwijderd';
        $strings['ReservationRequiresApproval'] = 'Let op! </br>Voordat je reservering definitef word moet deze eerst goedgekeurd worden. </br>Je aanvraag blijft in de wachtrij staan tot deze is goedgekeurd.';
        $strings['YourReferenceNumber'] = 'Uw referentie nummer is %s';
        $strings['UpdatingReservation'] = 'Wijzigen van reservering bezig';
        $strings['ChangeUser'] = 'Wijzig gebruiker';
        $strings['MoreResources'] = 'Extra bronnen';
        $strings['ReservationLength'] = 'Duur reservering';
        $strings['ParticipantList'] = 'Deelnemerslijst';
        $strings['AddParticipants'] = 'Voeg deelnemers toe';
        $strings['InviteOthers'] = 'Nodig anderen uit';
        $strings['AddResources'] = 'Voeg bron toe';
        $strings['AddAccessories'] = 'Voeg accessoires toe';
        $strings['Accessory'] = 'Accessoires';
        $strings['QuantityRequested'] = 'Hoeveelheid vereist';
        $strings['CreatingReservation'] = 'Bezig met aanmaken van de reservering';
        $strings['UpdatingReservation'] = 'Bezig met wijzigen van de reservering';
        $strings['DeleteWarning'] = 'Deze actie is permanent en niet terug te draaien!';
        $strings['DeleteAccessoryWarning'] = 'Deze Accessoires verwijderen betekent dat deze uit elke reserveringen verwijderd zal worden.';
        $strings['AddAccessory'] = 'Voeg Accessoires toe';
        $strings['AddBlackout'] = 'Voeg geblokkeerde periode toe';
        $strings['AllResourcesOn'] = 'Alle bronnen op';
        $strings['Reason'] = 'Oorzaak';
        $strings['BlackoutShowMe'] = 'Toon de conflicterende reserveringen';
        $strings['BlackoutDeleteConflicts'] = 'Verwijder conflicterende reserveringen';
        $strings['Filter'] = 'Filter';
        $strings['Between'] = 'Tussen';
        $strings['CreatedBy'] = 'Aangemaakt door';
        $strings['BlackoutCreated'] = 'Geblokkeerde tijd aangemaakt!';
        $strings['BlackoutNotCreated'] = 'Deze geblokkeerde periode kan niet aangemaakt worden';
        $strings['BlackoutUpdated'] = 'Geblokkeerde tijd bijgewerkt';
		$strings['BlackoutNotUpdated'] = 'Geblokkeerde tijd kon niet worden bijgewerkt';
        $strings['BlackoutConflicts'] = 'Er zijn conflicterende geblokkeerde periodes';
        $strings['ReservationConflicts'] = 'Er zijn conflicterende reservering periodes';
        $strings['UsersInGroup'] = 'Gebruikers in deze groep';
        $strings['Browse'] = 'Browse';
        $strings['DeleteGroupWarning'] = 'Deze groep verwijderen resulteert in het verwijderen van alle gekoppelde toegangsrechten op bronnen. Gebruikers in deze groep kunnen derhalve toegangsrechten verliezen.';
        $strings['WhatRolesApplyToThisGroup'] = 'Welke rollen behoren tot deze groep?';
        $strings['WhoCanManageThisGroup'] = 'Wie beheert deze groep?';
        $strings['WhoCanManageThisSchedule'] = 'Wie beheert deze planning?';
        $strings['AddGroup'] = 'Voeg groep toe';
        $strings['AllQuotas'] = 'Alle Kwotas';
        $strings['QuotaReminder'] = 'Opgelet: Kwotas worden toegepast op basis van de tijdzone van de planning.';
        $strings['AllReservations'] = 'Alle reserveringen';
        $strings['PendingReservations'] = 'Openstaande reserveringen';
        $strings['Approving'] = 'Te bevestigen';
        $strings['MoveToSchedule'] = 'Verplaats naar planning';
        $strings['DeleteResourceWarning'] = 'Deze bron verwijderen resulteert in het verwijderen van alle gelinkte informatie';
        $strings['DeleteResourceWarningReservations'] = 'alle gekoppelde afgelopen, huidige en toekomstige reserveringen';
        $strings['DeleteResourceWarningPermissions'] = 'alle gekoppelde toegangsrechten';
        $strings['DeleteResourceWarningReassign'] = 'Wijs alles opnieuw toe wat niet verwijderd mag worden voordat u verder gaat.';
        $strings['ScheduleLayout'] = 'Layout (all times %s)';
        $strings['ReservableTimeSlots'] = 'Reserveerbare tijdsslots';
        $strings['BlockedTimeSlots'] = 'Geblokkeerde tijdsslots';
        $strings['ThisIsTheDefaultSchedule'] = 'Dit is de standaard planning';
        $strings['DefaultScheduleCannotBeBroughtDown'] = 'De standaard planning kan niet omlaag gebracht worden';
        $strings['MakeDefault'] = 'Maak standaard';
        $strings['BringDown'] = 'Omlaag';
        $strings['ChangeLayout'] = 'Wijzig layout';
        $strings['AddSchedule'] = 'Voeg een planning toe';
        $strings['StartsOn'] = 'Begint op';
        $strings['NumberOfDaysVisible'] = 'Aantal zichtbare dagen';
        $strings['UseSameLayoutAs'] = 'Gebruik dezelfde layout als';
        $strings['Format'] = 'Formaat';
        $strings['OptionalLabel'] = 'Optionele label';
        $strings['LayoutInstructions'] = 'Voeg een slot toe per lijn. De volledige 24 uren van een dag moeten worden voorzien beginnend en eindigend om 12:00 AM.';
        $strings['AddUser'] = 'Gebruiker toevoegen';
        $strings['UserPermissionInfo'] = 'De concrete toegang tot de bronnen hangt af van uw rol, groepsrechten en externe toegangsrechten.';
        $strings['DeleteUserWarning'] = 'Wanneer u deze gebruiker verwijdert, worden alle reserveringen uit het verleden en toekomst gewist.';
        $strings['AddAnnouncement'] = 'Voeg een mededeling toe';
        $strings['Announcement'] = 'Mededeling';
        $strings['Priority'] = 'Prioriteit';
        $strings['Reservable'] = 'Te reserveren';
        $strings['Unreservable'] = 'Niet te reserveren';
        $strings['Reserved'] = 'Gereserveerd';
        $strings['MyReservation'] = 'Mijn reservering';
        $strings['Pending'] = 'In wachtlijst';
        $strings['Past'] = 'Verleden';
        $strings['Restricted'] = 'Restrictie';
        $strings['ViewAll'] = 'Bekijk Alles';
        $strings['MoveResourcesAndReservations'] = 'Verplaats bronnen en reserveringen naar';
        $strings['TurnOffSubscription'] = 'Meld abonnement van kalender af';
        $strings['TurnOnSubscription'] = 'Sta abonnement op deze kalender toe';
        $strings['SubscribeToCalendar'] = 'Abonneer op deze kalender';
        $strings['SubscriptionsAreDisabled'] = 'De administrator heeft het abonneren op deze kalender geblokkeerd';
        $strings['NoResourceAdministratorLabel'] = '(Geen Bron eigenaar)';
        $strings['WhoCanManageThisResource'] = 'Wie kan deze bron beheren?';
        $strings['ResourceAdministrator'] = 'Bron eigenaar';
        $strings['Private'] = 'Privé';
        $strings['Accept'] = 'Accepteer';
        $strings['Decline'] = 'Weiger';
        $strings['ShowFullWeek'] = 'Laat hele week zien';
        $strings['CustomAttributes'] = 'Aangepaste Attributen';
        $strings['AddAttribute'] = 'Voeg een attribuut toe';
        $strings['EditAttribute'] = 'Update een attribuut';
        $strings['DisplayLabel'] = 'Laat Label zien';
        $strings['Type'] = 'Type';
        $strings['Required'] = 'Verplicht';
        $strings['ValidationExpression'] = 'Validation Expression';
        $strings['PossibleValues'] = 'Mogelijke waarden';
        $strings['SingleLineTextbox'] = 'Tekstbox met elkele regel';
        $strings['MultiLineTextbox'] = 'Tekstbox met meerdere regels';
        $strings['Checkbox'] = 'Checkbox';
        $strings['SelectList'] = 'Selectie Lijst';
        $strings['CommaSeparated'] = 'komma gescheiden';
        $strings['Category'] = 'Categorie';
        $strings['CategoryReservation'] = 'Reservering';
        $strings['CategoryGroup'] = 'Groep';
        $strings['SortOrder'] = 'Sorteer Volgorde';
        $strings['Title'] = 'Titel';
        $strings['AdditionalAttributes'] = 'Extra Attributen';
        $strings['True'] = 'Waar';
        $strings['False'] = 'Onwaar';
        $strings['ForgotPasswordEmailSent'] = 'Een email is naar uw account gestuurd met de informatie om uw wachtwoord te resetten';
        $strings['ActivationEmailSent'] = 'Je ontvangt binnekort een email voor activatie.';
        $strings['AccountActivationError'] = 'Sorry, we hebben je account niet kunnen activeren.';
        $strings['Attachments'] = 'Bijlage';
        $strings['AttachFile'] = 'Voeg bestand toe';
        $strings['Maximum'] = 'max';
        $strings['NoScheduleAdministratorLabel'] = 'Geen Plannings Administrator';
        $strings['ScheduleAdministrator'] = 'Plannings Administrator';
        $strings['Total'] = 'Totaal';
        $strings['QuantityReserved'] = 'Aantal Gereserveerd';
        $strings['AllAccessories'] = 'Alle Accessoires';
        $strings['GetReport'] = 'Open Rapportage';
        $strings['NoResultsFound'] = 'Geen overeenkomende resultaten gevonden';
        $strings['SaveThisReport'] = 'Sla deze rapportage op';
        $strings['ReportSaved'] = 'Rapportage Opgeslagen!';
        $strings['EmailReport'] = 'Email Rapportage';
        $strings['ReportSent'] = 'Rapportage Verzonden!';
        $strings['RunReport'] = 'Draai Rapportage';
        $strings['NoSavedReports'] = 'Je hebt geen opgeslagen Rapportages.';
        $strings['CurrentWeek'] = 'Huidige Week';
        $strings['CurrentMonth'] = 'Huidige Maand';
        $strings['AllTime'] = 'Alle Tijd';
        $strings['FilterBy'] = 'Gefilter Op';
        $strings['Select'] = 'Selecteer';
        $strings['List'] = 'Lijst';
        $strings['TotalTime'] = 'Totale Tijd';
        $strings['Count'] = 'Aantal';
        $strings['Usage'] = 'Gebruik';
        $strings['AggregateBy'] = 'Gesorteerd op';
        $strings['Range'] = 'Breik';
        $strings['Choose'] = 'Kies';
        $strings['All'] = 'Alle';
        $strings['ViewAsChart'] = 'Bekijk als Grafiek';
        $strings['ReservedResources'] = 'Gereserveerde bronnen';
        $strings['ReservedAccessories'] = 'Gereserveerde accessoires';
        $strings['ResourceUsageTimeBooked'] = 'Bronnen gebruik - Tijd Geboekt';
        $strings['ResourceUsageReservationCount'] = 'Bronnen gebruik - Gereserveerd Aantal';
        $strings['Top20UsersTimeBooked'] = 'Top 20 Gebruikers - Tijd Geboekt';
        $strings['Top20UsersReservationCount'] = 'Top 20 Gebruikers - Gereserveerd Aantal';
        $strings['ConfigurationUpdated'] = 'Het configuratie bestand is geupdate';
        $strings['ConfigurationUiNotEnabled'] = 'Deze pagina kan niet worden geopent omdat $conf[\'settings\'][\'pages\'][\'enable.configuration\'] niet is geactiveerd of weg is.';
        $strings['ConfigurationFileNotWritable'] = 'Het configuratie bestand is niet schrijfbaar. Controleer de permissies en probeer opnieuw.';
        $strings['ConfigurationUpdateHelp'] = 'Raadpleeg de sectie Configuratie van het <a target=_blank href=%s>Help Bestand</a> voor documentatie van deze instellingen.';
        $strings['GeneralConfigSettings'] = 'instellingen';
        $strings['UseSameLayoutForAllDays'] = 'Gebruik de zelfde layout voor alle dagen';
        $strings['LayoutVariesByDay'] = 'Layout varieert per dag';
        $strings['ManageReminders'] = 'Herinneringen';
        $strings['ReminderUser'] = 'Gebuikers ID';
        $strings['ReminderMessage'] = 'Bericht';
        $strings['ReminderAddress'] = 'Adres';
        $strings['ReminderSendtime'] = 'Tijd om te versturen';
        $strings['ReminderRefNumber'] = 'Reserverings Referentie Nummer';
        $strings['ReminderSendtimeDate'] = 'Datum van Herinnering';
        $strings['ReminderSendtimeTime'] = 'Tijd van Herinnering (HH:MM)';
        $strings['ReminderSendtimeAMPM'] = 'AM / PM';
        $strings['AddReminder'] = 'Voeg Herinnering Toe';
        $strings['DeleteReminderWarning'] = 'Weet je dit zeker?';
        $strings['NoReminders'] = 'Je hebt geen toekomstige herinneringen.';
        $strings['Reminders'] = 'Herinneringen';
        $strings['SendReminder'] = 'Verstuur Herinnering';
        $strings['minutes'] = 'minuten';
        $strings['hours'] = 'uren';
        $strings['days'] = 'dagen';
        $strings['ReminderBeforeStart'] = 'voor de starttijd';
        $strings['ReminderBeforeEnd'] = 'voor de eindtijd';
        $strings['Logo'] = 'Logo';
        $strings['CssFile'] = 'CSS Bestand';
        $strings['ThemeUploadSuccess'] = 'Je veranderingen zijn opgeslagen. Vernieuw de pagina om wijzigingen door te voeren.';
        $strings['MakeDefaultSchedule'] = 'Maak dit mijn standaard planning';
        $strings['DefaultScheduleSet'] = 'Dit is nu jouw standaard planning';
        $strings['FlipSchedule'] = 'Flip de plannings layout';
        $strings['Next'] = 'Volgende';
        $strings['Success'] = 'Success';
        $strings['Participant'] = 'Deelnemer';
        $strings['ResourceFilter'] = 'Bron Filter';
        $strings['ResourceGroups'] = 'Bron Groepen';
        $strings['AddNewGroup'] = 'Voeg een nieuwe groep toe';
        $strings['Quit'] = 'Quit';
        $strings['AddGroup'] = 'Voeg Groep Toe';
        $strings['StandardScheduleDisplay'] = 'Gebruik de standaard plannings weergaven';
        $strings['TallScheduleDisplay'] = 'Gebruik lange plannings weergaven';
        $strings['WideScheduleDisplay'] = 'Gebruik brede plannings weergaven';
        $strings['CondensedWeekScheduleDisplay'] = 'Gebruik geconcentreerde week plannings weergaven';
        $strings['ResourceGroupHelp1'] = 'Slepen naar Bron groepen om te reorganiseren.';
        $strings['ResourceGroupHelp2'] = 'Klik rechts op een bron groepsnaam voor extra acties.';
        $strings['ResourceGroupHelp3'] = 'Sleep naar Bron om toe te voegen aan de groepen.';
        $strings['ResourceGroupWarning'] = 'Als je bron groepen gebruikt zal elke bron toegewezen moeten worden aan minstens een groep. Bronnen die niet zijn toegewezen kunnen niet gereserveerd worden.';
        $strings['ResourceType'] = 'Bron Type';
        $strings['AppliesTo'] = 'Toepassen op';
        $strings['UniquePerInstance'] = 'Unieke Per Instantie';
        $strings['AddResourceType'] = 'Voeg Bron Type Toe';
        $strings['NoResourceTypeLabel'] = '(geen bron type geselecteerd)';
        $strings['ClearFilter'] = 'Reset Filter';
        $strings['MinimumCapacity'] = 'Minimale Capaciteit';
        $strings['Color'] = 'Kleur';
        $strings['Available'] = 'Beschikbaar';
        $strings['Unavailable'] = 'Momenteel niet Beschikbaar';
        $strings['Hidden'] = 'Verborgen';
        $strings['ResourceStatus'] = 'Bron Status';
        $strings['CurrentStatus'] = 'Huidige Status';
        $strings['AllReservationResources'] = 'Alle Reserverings Bronnen';
        $strings['File'] = 'Bestand';
        $strings['BulkResourceUpdate'] = 'Bulk Bron update';
        $strings['Unchanged'] = 'Ongewijzigd';
        $strings['Common'] = 'Algemeen';
        $strings['AdminOnly'] = 'Alleen voor administrator';
        $strings['AdvancedFilter'] = 'Geavanceerde Filter';
        $strings['MinimumQuantity'] = 'Minimale hoeveelheid';
		$strings['MaximumQuantity'] = 'Maximale hoeveelheid';
		$strings['ChangeLanguage'] = 'Wijzig taal';
		$strings['AddRule'] = 'Voeg regel toe';
		$strings['Attribute'] = 'Attribuut';
		$strings['RequiredValue'] = 'Vereiste waarde';
		$strings['ReservationCustomRuleAdd'] = 'Gebruik deze kleur als de reservings attribuut de volgende waarde heeft';
		$strings['AddReservationColorRule'] = 'Voeg reserverings kleur regel toe';
		$strings['LimitAttributeScope'] = 'Verzamel in specifieke gevallen';
		$strings['CollectFor'] = 'Verzamel voor';
		$strings['SignIn'] = 'Log in';
		$strings['AllParticipants'] = 'Alle deelnemers';
		$strings['RegisterANewAccount'] = 'Registreer een nieuw account';
		$strings['Dates'] = 'Datums';
		$strings['More'] = 'Meer';
		$strings['ResourceAvailability'] = 'Beschikbaarheid';
		$strings['UnavailableAllDay'] = 'Hele dag niet beschikbaar';
		$strings['AvailableUntil'] = 'Eerstvolgende boeking';
		$strings['AvailableBeginningAt'] = 'Beschikbaar vanaf:';
        $strings['AvailableAt'] = 'Weer beschikbaar vanaf';
		$strings['AllResourceTypes'] = 'Alle bron soorten';
		$strings['AllResourceStatuses'] = 'Alle bron statusen';
		$strings['AllowParticipantsToJoin'] = 'Sta gebruikers toe om deel te nemen';
		$strings['Join'] = 'Deelnemen';
		$strings['YouAreAParticipant'] = 'Je bent deelnemer van deze reservering';
		$strings['YouAreInvited'] = 'Je bent uitgenodigd voor deze reservering';
		$strings['YouCanJoinThisReservation'] = 'Je bent uitgenodigd voor deze reservering';
		$strings['Import'] = 'Importeer';
		$strings['GetTemplate'] = 'Sjabloon ophalen';
		$strings['UserImportInstructions'] = '<ul><li>File must be in CSV format.</li><li>Username and email are required fields.</li><li>Attribute validity will not be enforced.</li><li>Leaving other fields blank will set default values and \'password\' as the user\'s password.</li><li>Use the supplied template as an example.</li></ul>';
		$strings['RowsImported'] = 'Rijen geimporteerd';
		$strings['RowsSkipped'] = 'Rijen overgeslagen';
		$strings['Columns'] = 'Colommen';
		$strings['Reserve'] = 'Reserveer';
		$strings['AllDay'] = 'Hele dag';
		$strings['Everyday'] = 'Elke dag';
		$strings['IncludingCompletedReservations'] = 'Inclusief voltooide reserveringen';
		$strings['NotCountingCompletedReservations'] = 'Exclusief voltooide reserveringen';
		$strings['RetrySkipConflicts'] = 'Sla conflicterende reserveringen over';
		$strings['Retry'] = 'Opnieuw proberen';
		$strings['RemoveExistingPermissions'] = 'Bestaande rechten verwijderen?';
		$strings['Continue'] = 'Ga verder';
		$strings['WeNeedYourEmailAddress'] = 'We hebbn je email adressen nodig voor een reservering';
		$strings['ResourceColor'] = 'Bron kleur';
		$strings['DateTime'] = 'Datum Tijd';
		$strings['AutoReleaseNotification'] = 'Automatisch vrijgegeven als er niet is ingecheckt binnen %s minuten';
		$strings['RequiresCheckInNotification'] = 'In-/uitchecken vereist';
		$strings['NoCheckInRequiredNotification'] = 'In-/uitchecken niet vereist';
		$strings['RequiresApproval'] = 'Vereist goedkeuring';
		$strings['CheckingIn'] = 'Aan het inchecken';
		$strings['CheckingOut'] = 'Aan het uitcheken';
		$strings['CheckIn'] = 'Incheken';
		$strings['CheckOut'] = 'Uitchecken';
		$strings['ReleasedIn'] = 'Vrijgegeven in';
		$strings['CheckedInSuccess'] = 'Je bent ingechekt';
		$strings['CheckedOutSuccess'] = 'Je bent uitgechekt';
		$strings['CheckInFailed'] = 'Je kon niet worden ingecheckt';
		$strings['CheckOutFailed'] = 'Je kon niet worden uitgecheckt';
		$strings['CheckInTime'] = 'Check-in tijd';
		$strings['CheckOutTime'] = 'Check-uit tijd';
		$strings['OriginalEndDate'] = 'Oorspronkelijke eind tijd';
		$strings['SpecificDates'] = 'Laat specifieke datums zien';
		$strings['Users'] = 'Gebruikers';
		$strings['Guest'] = 'Gast';
		$strings['ResourceDisplayPrompt'] = 'Bron om weer te geven';
		$strings['Credits'] = 'Credits';
		$strings['AvailableCredits'] = 'Beschikbare credits';
		$strings['CreditUsagePerSlot'] = 'Requires %s credits per slot (off peak)';
		$strings['PeakCreditUsagePerSlot'] = 'Requires %s credits per slot (peak)';
		$strings['CreditsRule'] = 'Je hebt niet voldoende credits. Credits benodigd: %s. Credits in account: %s';
		$strings['PeakTimes'] = 'Piekuren';
		$strings['AllYear'] = 'Heel jaar';
		$strings['MoreOptions'] = 'Meer opties';
		$strings['SendAsEmail'] = 'Als e-mail verzenden';
		$strings['UsersInGroups'] = 'Gebruikers in groepen';
		$strings['UsersWithAccessToResources'] = 'Gebruikers met toegang tot bronnen';
		$strings['AnnouncementSubject'] = 'Een nieuwe mededeling is gepost door %s';
		$strings['AnnouncementEmailNotice'] = 'Gebruikers ontvangen deze mededeling als e-mail';
		$strings['Day'] = 'Dag';
		$strings['NotifyWhenAvailable'] = 'Breng me op de hoogte wanneer beschikbaar';
		$strings['AddingToWaitlist'] = 'Je word toegevoegd aan de wacht lijst';
		$strings['WaitlistRequestAdded'] = 'Je ontvangt een melding als deze tijd beschikbaar komt';
		$strings['PrintQRCode'] = 'Print QR Code';
		$strings['FindATime'] = 'Vind een tijd';
		$strings['AnyResource'] = 'Elke bron';
		$strings['ThisWeek'] = 'Deze week';
		$strings['Hours'] = 'Uren';
		$strings['Minutes'] = 'Minuten';
        $strings['ImportICS'] = 'Importeer vanuit ICS';
        $strings['ImportQuartzy'] = 'Importeer vanuit Quartzy';
        $strings['OnlyIcs'] = 'Alleen *.ics bestanden kunnen worden geupload.';
        $strings['IcsLocationsAsResources'] = 'Locaties worden geimporteerd als bron.';
        $strings['IcsMissingOrganizer'] = 'Bij elk evenement waarbij een organisator ontbreekt, wordt de eigenaar ingesteld op de huidige gebruiker.';
        $strings['IcsWarning'] = 'Reserveringsregels worden niet afgedwongen - conflicten, duplicaten, enz. zijn mogelijk.';
		$strings['BlackoutAroundConflicts'] = 'Geblokkeerde periodes rond conflicterende reserveringen';
		$strings['DuplicateReservation'] = 'Dupliceer';
		$strings['UnavailableNow'] = 'Momenteel niet beschikbaar';
		$strings['ReserveLater'] = 'Later reserveren';
		$strings['CollectedFor'] = 'Verzameld voor';
		$strings['IncludeDeleted'] = 'Inclusief verwijderde reserveringen';
		$strings['Deleted'] = 'Verwijderd';
		$strings['Back'] = 'Terug';
		$strings['Forward'] = 'Verder';
		$strings['DateRange'] = 'Datum range';
		$strings['Copy'] = 'Kopier';
		$strings['Detect'] = 'Detecteer';
		$strings['Autofill'] = 'Automatisch invullen';
		$strings['NameOrEmail'] = 'naam of emaill';
		$strings['ImportResources'] = 'Importeer bronnen';
		$strings['ExportResources'] = 'Exporteer bronnen';
		$strings['ResourceImportInstructions'] = '<ul><li>File must be in CSV format with UTF-8 encoding.</li><li>Name is required field. Leaving other fields blank will set default values.</li><li>Status options are \'Available\', \'Unavailable\' and \'Hidden\'.</li><li>Color should be the hex value. ex) #ffffff.</li><li>Auto assign and approval columns can be true or false.</li><li>Attribute validity will not be enforced.</li><li>Comma separate multiple resource groups.</li><li>Durations can be specified in the format #d#h#m or HH:mm (1d3h30m or 27:30 for 1 day, 3 hours, 30 minutes)</li><li>Use the supplied template as an example.</li></ul>';
		$strings['ReservationImportInstructions'] = '<ul><li>File must be in CSV format with UTF-8 encoding.</li><li>Email, resource names, begin, and end are required fields.</li><li>Begin and end require full date time. Recommended format is YYYY-mm-dd HH:mm (2017-12-31 20:30).</li><li>Rules, conflicts, and valid time slots will not be checked.</li><li>Notifications will not be sent.</li><li>Attribute validity will not be enforced.</li><li>Comma separate multiple resource names.</li><li>Use the supplied template as an example.</li></ul>';
		$strings['AutoReleaseMinutes'] = 'Autorelease Minuten';
		$strings['CreditsPeak'] = 'Credits (peak)';
		$strings['CreditsOffPeak'] = 'Credits (off peak)';
		$strings['ResourceMinLengthCsv'] = 'Minimale duur van reservering';
		$strings['ResourceMaxLengthCsv'] = 'Maximale duur van reservering';
		$strings['ResourceBufferTimeCsv'] = 'Buffer tijd';
		$strings['ResourceMinNoticeAddCsv'] = 'Reservering Minimumaankondiging toevoegen';
		$strings['ResourceMinNoticeUpdateCsv'] = 'Minimale kennisgeving reserveringsupdate';
		$strings['ResourceMinNoticeDeleteCsv'] = 'Reservering Minimale kennisgeving verwijderen';
		$strings['ResourceMaxNoticeCsv'] = 'Reservation Maximum End';
		$strings['Export'] = 'Exporteer';
		$strings['DeleteMultipleUserWarning'] = 'Als je deze gebruikers verwijdert, worden al hun huidige, toekomstige en historische reserveringen verwijderd. Er worden geen e-mails verzonden.';
		$strings['DeleteMultipleReservationsWarning'] = 'Er worden geen e-mails verzonden';
		$strings['ErrorMovingReservation'] = 'Foutmelding bij het verplaatsen van de reservering';
        $strings['SelectUser'] = 'Selecteer gebruiker';
        $strings['InviteUsers'] = 'Gebruiker uitnodigen';
        $strings['InviteUsersLabel'] = 'Vul de email adressen in van de personen die je wil uitnodigen';
        $strings['ApplyToCurrentUsers'] = 'Toepassen op huidige gebruikers';
        $strings['ReasonText'] = 'Reden tekst';
        $strings['NoAvailableMatchingTimes'] = 'Er zijn geen beschikbare tijden die overeenkomen met je zoekopdracht';
        $strings['Schedules'] = 'Planningen';
        $strings['NotifyUser'] = 'Gebruiker op de hoogte stellen';
        $strings['UpdateUsersOnImport'] = 'Bestaande gebruiker bijwerken als e-mail al bestaat';
        $strings['UpdateResourcesOnImport'] = 'Bestaande gebruiker bijwerken als de naam al bestaat';
        $strings['Reject'] = 'Afwijzen';
        $strings['CheckingAvailability'] = 'Beschikbaarheid controleren';
        $strings['CreditPurchaseNotEnabled'] = 'Je hebt de mogelijkheid om credits te kopen niet ingeschakeld';
        $strings['CreditsCost'] = 'Kosten per credit';
        $strings['Currency'] = 'Munteenheid';
        $strings['PayPalClientId'] = 'Client ID';
        $strings['PayPalSecret'] = 'Geheid';
        $strings['PayPalEnvironment'] = 'Omgeving';
        $strings['Sandbox'] = 'Sandbox';
        $strings['Live'] = 'Live';
        $strings['StripePublishableKey'] = 'Publishable key';
        $strings['StripeSecretKey'] = 'Secret key';
        $strings['CreditsUpdated'] = 'Credit cost has been updated';
        $strings['GatewaysUpdated'] = 'Payment gateways have been updated';
        $strings['PurchaseSummary'] = 'Purchase Summary';
        $strings['EachCreditCosts'] = 'Each credit costs';
        $strings['Checkout'] = 'Checkout';
        $strings['Quantity'] = 'Quantity';
        $strings['CreditPurchase'] = 'Credit Purchase';
        $strings['EmptyCart'] = 'Your cart is empty.';
        $strings['BuyCredits'] = 'Buy Credits';
        $strings['CreditsPurchased'] = 'credits purchased.';
        $strings['ViewYourCredits'] = 'View your credits';
        $strings['TryAgain'] = 'Probeer opnieuw';
        $strings['PurchaseFailed'] = 'We had trouble processing your payment.';
        $strings['NoteCreditsPurchased'] = 'Credits purchased';
        $strings['CreditsUpdatedLog'] = 'Credits updated by %s';
        $strings['ReservationCreatedLog'] = 'Reservation created. Reference number %s';
        $strings['ReservationUpdatedLog'] = 'Reservation updated. Reference number %s';
        $strings['ReservationDeletedLog'] = 'Reservation deleted. Reference number %s';
        $strings['BuyMoreCredits'] = 'Buy More Credits';
        $strings['Transactions'] = 'Transactions';
        $strings['Cost'] = 'Cost';
        $strings['PaymentGateways'] = 'Payment Gateways';
        $strings['CreditHistory'] = 'Credit History';
        $strings['TransactionHistory'] = 'Transaction History';
        $strings['Date'] = 'Datum';
        $strings['Note'] = 'Notitie';
        $strings['CreditsBefore'] = 'Credits Before';
        $strings['CreditsAfter'] = 'Credits After';
        $strings['TransactionFee'] = 'Transaction Fee';
        $strings['InvoiceNumber'] = 'Invoice Number';
        $strings['TransactionId'] = 'Transaction ID';
        $strings['Gateway'] = 'Gateway';
        $strings['GatewayTransactionDate'] = 'Gateway Transaction Date';
        $strings['Refund'] = 'Refund';
        $strings['IssueRefund'] = 'Issue Refund';
        $strings['RefundIssued'] = 'Refund Issued Successfully';
        $strings['RefundAmount'] = 'Refund Amount';
        $strings['AmountRefunded'] = 'Refunded';
        $strings['FullyRefunded'] = 'Fully Refunded';
        $strings['YourCredits'] = 'Your Credits';
        $strings['PayWithCard'] = 'Pay with Card';
        $strings['or'] = 'or';
        $strings['CreditsRequired'] = 'Credits Required';
        $strings['AddToGoogleCalendar'] = 'Toevoegen aan Google calendar';
        $strings['Image'] = 'Afbeelding';
        $strings['ChooseOrDropFile'] = 'Kies een bestand of sleep het hier heen';
        $strings['SlackBookResource'] = 'Reserveer %s nu';
        $strings['SlackBookNow'] = 'Reserveer nu';
        $strings['SlackNotFound'] = 'We konden geen bron met die naam vinden. Boek nu om een ​​nieuwe reservering te starten.';
        $strings['AutomaticallyAddToGroup'] = 'Voeg automatisch nieuwe gebruikers toe aan deze groep';
        $strings['GroupAutomaticallyAdd'] = 'Auto Add';
        $strings['TermsOfService'] = 'Servicevoorwaarden';
        $strings['EnterTermsManually'] = 'Voorwaarden handmatig invoeren';
        $strings['LinkToTerms'] = 'Link naar voorwaarden';
        $strings['UploadTerms'] = 'Voorwaarden uploaden';
        $strings['RequireTermsOfServiceAcknowledgement'] = 'Require Terms of Service Acknowledgement';
        $strings['UponReservation'] = 'Bij reservering';
        $strings['UponRegistration'] = 'Na registratie';
        $strings['ViewTerms'] = 'Servicevoorwaarden bekijken';
        $strings['IAccept'] = 'Ik accepteer';
        $strings['TheTermsOfService'] = 'de servicevoorwaarden';
        $strings['DisplayPage'] = 'Pagina weergeven';
        $strings['AvailableAllYear'] = 'Heel jaar';
        $strings['Availability'] = 'Beschikbaarheid';
        $strings['AvailableBetween'] = 'Beschikbaar tussen';
        $strings['ConcurrentYes'] = 'Bronnen kunnen door meer dan één persoon tegelijk worden geboekt';
        $strings['ConcurrentNo'] = 'Bronnen kunnen niet door meer dan één persoon tegelijk worden geboekt';
        $strings['ScheduleAvailabilityEarly'] = 'Deze planning is nog niet beschikbaar. Het is beschikbaar';
        $strings['ScheduleAvailabilityLate'] = 'Deze plannign is niet meer beschikbaar.';
        $strings['ResourceImages'] = 'Bron afbeeldingen';
        $strings['FullAccess'] = 'Volledige toegang';
        $strings['ViewOnly'] = 'Alleen kijken';
        $strings['Purge'] = 'Zuiveren';
        $strings['UsersWillBeDeleted'] = 'Gebruikers zullen worden verwijderd';
        $strings['BlackoutsWillBeDeleted'] = 'Geblokkeerde periodes worden verwijderd';
        $strings['ReservationsWillBePurged'] = 'Reserveringen worden geuiverd';
        $strings['ReservationsWillBeDeleted'] = 'reserveringen worden verwijderd';
        $strings['PermanentlyDeleteUsers'] = 'Gebruikers permanent verwijderen die zich sindsdien niet meer hebben aangemeld';
        $strings['DeleteBlackoutsBefore'] = 'Delete blackout times before';
        $strings['DeletedReservations'] = 'Verwijderde reserveringen';
        $strings['DeleteReservationsBefore'] = 'Reserverinmgen verwijderen voor';
        $strings['SwitchToACustomLayout'] = 'Schakel naar een aangepaste layout';
        $strings['SwitchToAStandardLayout'] = 'Schakel naar de standaard layout';
        $strings['ThisScheduleUsesACustomLayout'] = 'Deze planning gebruikt een aangepaste layout';
        $strings['ThisScheduleUsesAStandardLayout'] = 'Deze planning gebruikt een standaard layout';
        $strings['SwitchLayoutWarning'] = 'Weet je zeker dat je het lay-outtype wilt wijzigen? Hiermee worden alle bestaande slots verwijderd.';
        $strings['DeleteThisTimeSlot'] = 'Dit tijdslot verwijderen?';
        $strings['Refresh'] = 'Vernieuwen';
        $strings['ViewReservation'] = 'Bekijk reservering';
        $strings['PublicId'] = 'Public Id';
        $strings['Public'] = 'Public';
        $strings['AtomFeedTitle'] = '%s reserveringen';
        $strings['DefaultStyle'] = 'Standaard style';
        $strings['Standard'] = 'Standaard';
        $strings['Wide'] = 'Breed';
        $strings['Tall'] = 'Hoog';
        $strings['EmailTemplate'] = 'Email sjabloon';
        $strings['SelectEmailTemplate'] = 'Selecteer Email sjabloon';
        $strings['ReloadOriginalContents'] = 'Originele inhoud opnieuw laden';
        $strings['UpdateEmailTemplateSuccess'] = 'Bijgewerkt e-mailsjabloon';
        $strings['UpdateEmailTemplateFailure'] = 'Kan e-mailsjabloon niet updaten. Controleer of de map beschrijfbaar is.';
        $strings['BulkResourceDelete'] = 'Bulk bron verwijderen';
        $strings['NewVersion'] = 'Nieuwe versie!';
        $strings['WhatsNew'] = 'Wat is er nieuw?';
        $strings['OnlyViewedCalendar'] = 'Dit schema kan alleen worden bekeken vanuit de kalenderweergave';
        $strings['Grid'] = 'Grid';
        $strings['List'] = 'Lijst';
        $strings['NoReservationsFound'] = 'Geen reserveringen gevonden';
        $strings['EmailReservation'] = 'Mail reservering';
        $strings['AdHocMeeting'] = 'Ad hoc Meeting';
        $strings['NextReservation'] = 'Volgende Reservering';
        $strings['MissedCheckin'] = 'Gemiste Checkin';
        $strings['MissedCheckout'] = 'Gemiste Checkout';
        $strings['Utilization'] = 'Gebruik';
        $strings['SpecificTime'] = 'Specifieke tijd';
        $strings['ReservationSeriesEndingPreference'] = 'Wanneer mijn terugkerende reserveringsreeks afloopt';
        $strings['NotAttending'] = 'Niet aanwezig';
        $strings['ViewAvailability'] = 'Beschikbaarheid bekijken';
        $strings['ReservationDetails'] = 'Reserveringsdetails';
        $strings['StartTime'] = 'Starttijd';
        $strings['EndTime'] = 'Eindtijd';
        $strings['New'] = 'Nieuw';
        $strings['Updated'] = 'Bijgewerkt';
        $strings['Custom'] = 'Aangepast';
        $strings['AddDate'] = 'Datum toevoegen';
        $strings['RepeatOn'] = 'Herhalen op';
        $strings['ScheduleConcurrentMaximum'] = 'In totaal kunnen tegelijkertijd <b>%s</b> bronnen worden gereserveerd';
        $strings['ScheduleConcurrentMaximumNone'] = 'Er is geen limiet aan het aantal gelijktijdige gereserveerde bronnen';
        $strings['ScheduleMaximumConcurrent'] = 'Maximaal aantal gelijktijdig gereserveerde resources';
        $strings['ScheduleMaximumConcurrentNote'] = 'Indien ingesteld, is het totale aantal resources dat gelijktijdig voor dit schema kan worden gereserveerd, beperkt.';
        $strings['ScheduleResourcesPerReservationMaximum'] = 'Elke reservering is beperkt tot maximaal <b>%s</b> resources';
        $strings['ScheduleResourcesPerReservationNone'] = 'Er is geen limiet aan het aantal bronnen per reservering';
        $strings['ScheduleResourcesPerReservation'] = 'Maximaal aantal bronnen per reservering';
        $strings['ResourceConcurrentReservations'] = 'Sta %s gelijktijdige reserveringen toe';
        $strings['ResourceConcurrentReservationsNone'] = 'Gelijktijdige reserveringen niet toestaan';
        $strings['AllowConcurrentReservations'] = 'Gelijktijdige reserveringen toestaan';
        $strings['ResourceDisplayInstructions'] = 'Er is geen bron geselecteerd. U kunt de URL vinden om een ​​bron weer te geven in Applicatie beheer, Resources. De bron moet openbaar toegankelijk zijn.';
        $strings['Owner'] = 'Eigenaar';
		$strings['MaximumConcurrentReservations'] = 'Maximale gelijktijdige reserveringen';
		$strings['NotifyUsers'] = 'Informeer gebruikers';
		$strings['Message'] = 'Bericht';
		$strings['AllUsersWhoHaveAReservationInTheNext'] = 'Iedereen met een reservering in de volgende';
		$strings['ChangeResourceStatus'] = 'Bronstatus wijzigen';
		$strings['UpdateGroupsOnImport'] = 'Bestaande groep bijwerken als naam overeenkomt';
		$strings['GroupsImportInstructions'] = '<ul><li>File must be in CSV format.</li><li>Name is required.</li><li>Member lists should be comma separated lists of emails.</li><li>Empty member lists when updating groups will leave members unchanged.</li><li>Permissions lists should be comma separated lists of resource names.</li><li>Empty permissions lists when updating groups will leave permissions unchanged.</li><li>Use the supplied template as an example.</li></ul>';
		$strings['PhoneRequired'] = 'Telefoon is vereist';
		$strings['OrganizationRequired'] = 'Kazerne is vereist';
		$strings['PositionRequired'] = 'Positie is vereist';
		$strings['GroupMembership'] = 'Groepslidmaatschap';
		$strings['AvailableGroups'] = 'Beschikbare groepen';
		$strings['CheckingAvailabilityError'] = 'Kan de beschikbaarheid van bronnen niet krijgen - te veel bronnen';
        // End Strings

        // Install
        $strings['InstallApplication'] = 'Installeer LibreBooking (MySQL only)';
        $strings['IncorrectInstallPassword'] = 'Sorry, dat wachtwoord is onjuist.';
        $strings['SetInstallPassword'] = 'Je moet een wachtwoord instellen voordat de installatie kan worden uitgevoerd.';
        $strings['InstallPasswordInstructions'] = 'In %s wijzig %s naar een moeilijk wachtwoord dat moeilijk te raden is en ga dan terug naar deze pagina.<br/>Je kan %s gebruiken';
        $strings['NoUpgradeNeeded'] = 'Er is geen upgrade nodig. De installatie zal alle bestaande data verwijderen en zal een nieuwe kopie gemaakt worden van LibreBooking!';
        $strings['ProvideInstallPassword'] = 'Geef het wachtwoord van tijdens de installatie op.';
        $strings['InstallPasswordLocation'] = 'Dit kan worden gevonden bij %s in %s.';
        $strings['VerifyInstallSettings'] = 'Controleer de volgende standaardinstellingen voordat je verder gaat. Of je kan ze veranderen in %s.';
        $strings['DatabaseName'] = 'Database Naam';
        $strings['DatabaseUser'] = 'Database Gebruiker';
        $strings['DatabaseHost'] = 'Database Host';
        $strings['DatabaseCredentials'] = 'Je moet een account van MySQL gebruiken die rechten heeft om databases te maken. Als je die niet weet, neem dan contact op met je database administrator. In veel gevallen zal de root account werken.';
        $strings['MySQLUser'] = 'MySQL Account';
        $strings['InstallOptionsWarning'] = 'De volgende opties zullen waarschijnlijk niet werken in een gehoste omgeving. Als je in een gehoste omgeving installeerd, gebruik dan de MySQL wizard om deze stappen uit te voeren.';
        $strings['CreateDatabase'] = 'Maak de database';
        $strings['CreateDatabaseUser'] = 'Maak de database account';
        $strings['PopulateExampleData'] = 'Import voorbeeld data. Maak administrator account: admin/password en gebruiker account: user/password';
        $strings['DataWipeWarning'] = 'Let op: Dit zal alle bestaande data verwijderen';
        $strings['RunInstallation'] = 'Start Installatie';
        $strings['UpgradeNotice'] = 'Je zal nu upgraden van versie <b>%s</b> naar versie <b>%s</b>';
        $strings['RunUpgrade'] = 'Start Upgrade';
        $strings['Executing'] = 'Uitvoeren';
        $strings['StatementFailed'] = 'Mislukt. Details:';
        $strings['SQLStatement'] = 'SQL Statement:';
        $strings['ErrorCode'] = 'Error Code:';
        $strings['ErrorText'] = 'Error Tekst:';
        $strings['InstallationSuccess'] = 'Installatie succesvol afgerond!';
        $strings['RegisterAdminUser'] = 'Registreer je administrator account. Dit is noodzakelijk als je de voorbeeld data niet geimporteerd hebt. Zorg ervoor dat $conf[\'settings\'][\'allow.self.registration\'] = \'true\' in je %s bestand.';
        $strings['LoginWithSampleAccounts'] = 'Als je de voorbeeld data geimporteerd hebt, kan je inloggen met admin/password voor de administrator account of user/password voor de standaard gebruiker.';
        $strings['InstalledVersion'] = 'Je zit nu op versie %s van LibreBooking';
        $strings['InstallUpgradeConfig'] = 'Het is aanbevolen om je config bestand to upgraden';
        $strings['InstallationFailure'] = 'Er waren problemen met de installatie. Graag deze corrigeren en probeer de installatie opnieuw.';
        $strings['ConfigureApplication'] = 'Configureer LibreBooking';
        $strings['ConfigUpdateSuccess'] = 'Je configuratie bestand is nu bijgewerkt!';
        $strings['ConfigUpdateFailure'] = 'We konden het configuratie bestand niet automatisch updaten. Overschrijf de inhoud van config.php met het volgende:';
        $strings['SelectUser'] = 'Select User';

        // Errors
        $strings['LoginError'] = 'Ongeldige gebruikersnaam of wachtwoord opgegeven';
        $strings['ReservationFailed'] = 'Uw reservering kan niet worden uitgevoerd';
        $strings['MinNoticeError'] = 'Deze reservering moet op voorhand worden aangevraagd. De vroegste reserveringsdatum is %s.';
        $strings['MinNoticeErrorUpdate'] = 'Het wijzigen van deze reservering vereist voorafgaande kennisgeving. Reserveringen vóór %s mogen niet worden gewijzigd.';
		$strings['MinNoticeErrorDelete'] = 'Het verwijderen van deze reservering vereist voorafgaande kennisgeving. Reserveringen vóór %s mogen niet worden verwijderd.';
        $strings['MaxNoticeError'] = 'Deze reservering kan niet zover in de toekomst worden gemaakt. De uiterste reserveringsdatum in de toekomst is %s.';
        $strings['MinDurationError'] = 'Deze reservering moet een minimum duur hebben van %s.';
        $strings['MaxDurationError'] = 'Deze reservering kan niet langer duren dan %s.';
        $strings['ConflictingAccessoryDates'] = 'Er zijn onvoldoende benodigheden voorradig:';
        $strings['NoResourcePermission'] = 'U hebt onvoldoende rechten om toegang tot een of meerdere van de bronnen te verkrijgen';
        $strings['ConflictingReservationDates'] = 'Er zijn conflicterende reserveringen op volgende data:';
        $strings['InstancesOverlapRule'] = 'Sommige exemplaren van de reserveringsreeks overlappen elkaar:';
        $strings['StartDateBeforeEndDateRule'] = 'De startdatum moet voor de einddatum liggen';
        $strings['StartIsInPast'] = 'Een startdatum in het verleden is ongeldig';
        $strings['EmailDisabled'] = 'De beheerder zette de optie email meldingen af';
        $strings['ValidLayoutRequired'] = 'Slots moeten voor de volledige 24 uren van de dag voorzien worden, beginnend en eindigend om 12:00 AM.';
        $strings['CustomAttributeErrors'] = 'Er zijn problemen met de extra attributen die je ingevuld hebt:';
        $strings['CustomAttributeRequired'] = '%s is een verplicht veld.';
        $strings['CustomAttributeInvalid'] = 'De ingevulde waarde van %s is incorrect.';
        $strings['AttachmentLoadingError'] = 'Sorry, er was a probleem om het opgevraagde bestand te laden.';
        $strings['InvalidAttachmentExtension'] = 'Je kan alleen bestanden uploaden met het extentietype: %s';
        $strings['InvalidStartSlot'] = 'De gevraagde startdatum en tijd is ongeldig.';
        $strings['InvalidEndSlot'] = 'De gevraagde einddatum en tijd is ongeldig.';
        $strings['MaxParticipantsError'] = '%s ondersteunt slechts %s deelnemers.';
        $strings['ReservationCriticalError'] = 'Er was een kritieke fout bij het opslaan van je reservering. Als dit zich herhaalt, neem dan contact op met je systeembeheerder.';
        $strings['InvalidStartReminderTime'] = 'De starttijd van de herrinnering is ongeldig.';
        $strings['InvalidEndReminderTime'] = 'De eindtijd van de herrinnering is ongeldig.';
		$strings['QuotaExceeded'] = 'Quota limiet overschreden.';
        $strings['MultiDayRule'] = '%s staat reserveringen over meerdere dagen niet toe.';
        $strings['InvalidReservationData'] = 'Er was een probleem met je reserverings aanvraag.';
		$strings['PasswordError'] = 'Wachtwoord moet minstens %s letters en minstens %s nummers.';
        $strings['PasswordErrorRequirements'] = 'Wachtwoord moet een combinatie van minstens %s hoofdletters en kleine letters en %s nummers.';
        $strings['NoReservationAccess'] = 'Je hebt geen rechten om deze reservering te wijzigen.';
        $strings['PasswordControlledExternallyError'] = 'Je wachtwoord wordt beheerd door een extern systeem en kan hier niet worden bijgewerkt.';
		$strings['AccessoryResourceRequiredErrorMessage'] = 'Accessoire %s kan alleen gereserveerd worden met deze bronnen: %s';
		$strings['AccessoryMinQuantityErrorMessage'] = 'Er moeten minimaal %s stuks van accessoire %s worden gereserveerd';
		$strings['AccessoryMaxQuantityErrorMessage'] = 'Er kunnen niet meer dan %s stuks van accessoire %s worden gereserveerd';
		$strings['AccessoryResourceAssociationErrorMessage'] = 'Accessoire \'%s\' kan niet met de geselecteerde bron worden gereserveerd';
		$strings['NoResources'] = 'Je hebt geen bronnen toegevoegd';
		$strings['ParticipationNotAllowed'] = 'Je bent niet geautoriseerd om deel te nemen aan deze boeking.';
		$strings['ReservationCannotBeCheckedInTo'] = 'Deze reservering kan niet ingecheckt worden.';
		$strings['ReservationCannotBeCheckedOutFrom'] = 'Deze reservering kan niet uitgecheckt worden.';
		$strings['InvalidEmailDomain'] = 'Dat e-mailadres is niet van een toegestaan ​​domein';
		$strings['TermsOfServiceError'] = 'Accepteer de voorwaarden a.u.b.';
		$strings['UserNotFound'] = 'Gebruiker kan niet worden gevonden';
		$strings['ScheduleAvailabilityError'] = 'Deze planning is beschikbaar tussen %s en %s';
		$strings['ReservationNotFoundError'] = 'Boeking niet gevonden';
		$strings['ReservationNotAvailable'] = 'Boeking niet beschikbaar';
		$strings['TitleRequiredRule'] = 'Reserverings titel is verplicht';
		$strings['DescriptionRequiredRule'] = 'Reserverings omschrijving is verplicht';
		$strings['WhatCanThisGroupManage'] = 'Wat kan deze groep beheren?';
		$strings['ReservationParticipationActivityPreference'] = 'Wanneer iemand bij mijn reservering komt of deze verlaat';
		$strings['RegisteredAccountRequired'] = 'Alleen geregistreerde gebruikers kunnen reserveringen maken';
		$strings['InvalidNumberOfResourcesError'] = 'Het maximale aantal bronnen dat kan worden gereserveerd in een enkele reservering is %s';
		$strings['ScheduleTotalReservationsError'] = 'Met dit schema kunnen alleen %s bronnen gelijktijdig worden gereserveerd. Deze reservering zou die limiet op de volgende data schenden:';
		// End Errors

        // Page Titles
        $strings['SearchReservations'] = 'Zoek naar reserveringen';
		$strings['FindATime'] = 'Vind een tijd';
        $strings['CreateReservation'] = 'Maak een reservering';
        $strings['EditReservation'] = 'Wijzig reservering';
        $strings['LogIn'] = 'Inloggen';
        $strings['ManageReservations'] = 'Reserveringen';
        $strings['AwaitingActivation'] = 'Wachtend op activatie';
        $strings['PendingApproval'] = 'Wachtend op goedkeuring';
        $strings['ManageSchedules'] = 'Planningen';
        $strings['ManageResources'] = 'Bronnen';
        $strings['ManageAccessories'] = 'Accessoires';
        $strings['ManageUsers'] = 'Gebruikers';
        $strings['ManageGroups'] = 'Groepen';
        $strings['ManageQuotas'] = 'Quotas';
        $strings['ManageBlackouts'] = 'Geblokkeerde periodes';
        $strings['MyDashboard'] = 'Mijn Dashboard';
        $strings['ServerSettings'] = 'Server instellingen';
        $strings['Dashboard'] = 'Dashboard';
        $strings['Help'] = 'Help';
        $strings['Administration'] = 'Administration';
		$strings['About'] = 'Over';
		$strings['Bookings'] = 'Weekoverzicht';
		$strings['Schedule'] = 'Kalender';
        $strings['Bookings'] = 'Boekingen';
        $strings['Schedule'] = 'Planning';
        $strings['Reservations'] = 'Reserveringen';
        $strings['Account'] = 'Account';
        $strings['EditProfile'] = 'Wijzig mijn profiel';
        $strings['FindAnOpening'] = 'Een mogelijkheid zoeken';
        $strings['OpenInvitations'] = 'Open uitnodigingen';
        $strings['MyCalendar'] = 'Mijn kalender';
        $strings['ResourceCalendar'] = 'Bron kalender';
        $strings['Reservation'] = 'Nieuwe reservering';
        $strings['Install'] = 'Installatie';
        $strings['ChangePassword'] = 'Wijzig wachtwoord';
        $strings['MyAccount'] = 'Mijn account';
        $strings['Profile'] = 'Profiel';
        $strings['ApplicationManagement'] = 'Applicatie beheer';
        $strings['ForgotPassword'] = 'Wachtwoord vergeten / voor de eerste keer inloggen';
        $strings['NotificationPreferences'] = 'Melding voorkeuren';
        $strings['ManageAnnouncements'] = 'Mededelingen';
        $strings['Responsibilities'] = 'Beheer';
        $strings['GroupReservations'] = 'Groep reserveringen';
        $strings['ResourceReservations'] = 'Bron reserveringen';
        $strings['Customization'] = 'Customization';
        $strings['Attributes'] = 'Attributen';
        $strings['AccountActivation'] = 'Account Activatie';
        $strings['ScheduleReservations'] = 'Reserveringen';
        $strings['Reports'] = 'Rapporten';
        $strings['GenerateReport'] = 'Maak Nieuw Raport';
        $strings['MySavedReports'] = 'Mijn Opgeslagen Rapporten';
        $strings['CommonReports'] = 'Algemene Rapporten';
        $strings['ViewDay'] = 'Bekijk Dag';
        $strings['Group'] = 'Groep';
        $strings['ManageConfiguration'] = 'Applicatie Configuratie';
        $strings['LookAndFeel'] = 'Vormgeving';
        $strings['ManageResourceGroups'] = 'Bron Groepen';
        $strings['ManageResourceTypes'] = 'Bron Types';
        $strings['ManageResourceStatus'] = 'Bron Statussen';
        $strings['ReservationColors'] = 'Reserverings kleur';
		$strings['SearchReservations'] = 'Zoek reservering';
		$strings['ManagePayments'] = 'Betalingen';
		$strings['ViewCalendar'] = 'Bekijk kalender';
		$strings['DataCleanup'] = 'Data opschonen';
		$strings['ManageEmailTemplates'] = 'E-mail sjablonen beheren';

        // End Page Titles

        // Day representations
        $strings['DaySundaySingle'] = 'Z';
        $strings['DayMondaySingle'] = 'M';
        $strings['DayTuesdaySingle'] = 'D';
        $strings['DayWednesdaySingle'] = 'W';
        $strings['DayThursdaySingle'] = 'D';
        $strings['DayFridaySingle'] = 'V';
        $strings['DaySaturdaySingle'] = 'Z';

        $strings['DaySundayAbbr'] = 'Zon';
        $strings['DayMondayAbbr'] = 'Maa';
        $strings['DayTuesdayAbbr'] = 'Din';
        $strings['DayWednesdayAbbr'] = 'Woe';
        $strings['DayThursdayAbbr'] = 'Don';
        $strings['DayFridayAbbr'] = 'Vri';
        $strings['DaySaturdayAbbr'] = 'Zat';
        // End Day representations

        // Email Subjects
		$strings['ReservationApprovedSubject'] = 'Je reservering is goedgekeurd';
		$strings['ReservationCreatedSubject'] = 'Je reservering is aangemaakt';
		$strings['ReservationUpdatedSubject'] = 'Je reservering is aangepast';
		$strings['ReservationDeletedSubject'] = 'Je reservering is verwijderd';
        $strings['ReservationCreatedAdminSubject'] = 'Melding: Een reservering is aangemaakt';
        $strings['ReservationUpdatedAdminSubject'] = 'Melding: Een reservering is aangepast';
        $strings['ReservationDeleteAdminSubject'] = 'Melding: Een reservering is verwijderd';
		$strings['ReservationApprovalAdminSubject'] = 'Melding: Een reservering heeft je goedkeuring nodig';
        $strings['ParticipantAddedSubject'] = 'Melding: deelname aan een reservering';
        $strings['ParticipantDeletedSubject'] = 'Melding: Reservering verwijderd';
        $strings['InviteeAddedSubject'] = 'Uitnodiging reservering';
        $strings['ResetPassword'] = 'Verzoek om wachtwoord te resetten';
		$strings['ResetPasswordRequest'] = 'Verzoek om wachtwoord te resetten';
		$strings['ActivateYourAccount'] = 'Activeer je account';
        $strings['ReportSubject'] = 'Je Opgevraagde Rapport (%s)';
        $strings['ReservationStartingSoonSubject'] = 'Reservering voor %s start binnenkort';
		$strings['ReservationEndingSoonSubject'] = 'Reservering voor %s eindigt binnekort';
        $strings['UserAdded'] = 'Een nieuwe gebruiker is toegevoegd.';
        $strings['UserDeleted'] = 'Het account voor %s is verwijderd door %s';
		$strings['GuestAccountCreatedSubject'] = 'Jouw %s account details';
		$strings['AccountCreatedSubject'] = 'Jouw %s account details';
		$strings['InviteUserSubject'] = '%s heeft je uitgenodigd om deel te nemen aan %s';

		$strings['ReservationApprovedSubjectWithResource'] = 'Reservering is goedgekeurd voor %s';
		$strings['ReservationCreatedSubjectWithResource'] = 'Reservering aangemaakt voor %s';
		$strings['ReservationUpdatedSubjectWithResource'] = 'Reservering bijgewerkt voor %s';
		$strings['ReservationDeletedSubjectWithResource'] = 'Reservering verwijderd voor %s';
		$strings['ReservationCreatedAdminSubjectWithResource'] = 'Melding: Reservering aangemaakt voor %s';
		$strings['ReservationUpdatedAdminSubjectWithResource'] = 'Melding: Reservering bijgewerkt voor %s';
		$strings['ReservationDeleteAdminSubjectWithResource'] = 'Melding: Reservering verwijderd voor %s';
		$strings['ReservationApprovalAdminSubjectWithResource'] = 'Melding: Reservering voor %s heeft je goedkeuring nodig';
		$strings['ParticipantAddedSubjectWithResource'] = '%s heeft je toegevoegd aan een reservering voor %s';
		$strings['ParticipantUpdatedSubjectWithResource'] = '%s heeft een reservering bijgewerkt voor %s';
		$strings['ParticipantDeletedSubjectWithResource'] = '%s heft een reservering verwijderd voor %s';
		$strings['InviteeAddedSubjectWithResource'] = '%s heeft je uitgenodigd voor een reservering voor %s';
		$strings['MissedCheckinEmailSubject'] = 'Gemiste check-in voor %s';
		$strings['ReservationShareSubject'] = '%s heeft een reservering gedeeld voor %s';
		$strings['ReservationSeriesEndingSubject'] = 'Reserveringsreeks voor %s eindigt op %s';
		$strings['ReservationParticipantAccept'] = '%s heeft uw reserveringsuitnodiging voor %s op %s . geaccepteerd';
		$strings['ReservationParticipantDecline'] = '%s heeft uw reserveringsuitnodiging voor %s op %s . afgewezen';
		$strings['ReservationParticipantJoin'] = '%s heeft zich aangesloten bij uw reservering voor %s op %s';
		$strings['ReservationAvailableSubject'] = '%s is beschikbaar op %s';
		$strings['ResourceStatusChangedSubject'] = 'De beschikbaarheid van %s is gewijzigd';
		// End Email Subjects

        //NEEDS CHECKING
        //Past Reservations
        $strings['NoPastReservations'] = 'U heeft geen eerdere reserveringen';
        $strings['PastReservations'] = 'Eerdere reserveringen';
        $strings['AllNoPastReservations'] = 'Er zijn geen eerdere reserveringen in de afgelopen %s dagen';
        $strings['AllPastReservations'] = 'Alle eerdere reserveringen';
        $strings['Yesterday'] = 'Gisteren';
        $strings['EarlierThisWeek'] = 'Eerder deze week';
        $strings['PreviousWeek'] = 'Vorige week';
        //End Past Reservations

        //Group Upcoming Reservations
        $strings['NoGroupUpcomingReservations'] = 'Uw groep heeft geen toekomstige reserveringen';
        $strings['GroupUpcomingReservations'] = 'Aankomende reserveringen van mijn groep(en)';
        //End Group Upcoming Reservations 

        //Facebook Login SDK Error
        $strings['FacebookLoginErrorMessage'] = 'Er is een fout opgetreden bij het inloggen met Facebook. Probeer het opnieuw.';
        //End Facebook Login SDK Error

        //Pending Approval Reservations in Dashboard
        $strings['NoPendingApprovalReservations'] = 'U heeft geen reserveringen die wachten op goedkeuring';
        $strings['PendingApprovalReservations'] = 'Reserveringen in afwachting van goedkeuring';
        $strings['LaterThisMonth'] = 'Later deze maand';
        $strings['LaterThisYear'] = 'Later dit jaar';
        $strings['Remaining'] = 'Resterend';     
        //End Pending Approval Reservations in Dashboard

        //Missing Check In/Out Reservations in Dashboard
        $strings['NoMissingCheckOutReservations'] = 'Er zijn geen ontbrekende uitcheckreserveringen';
        $strings['MissingCheckOutReservations'] = 'Ontbrekende uitcheckreserveringen';        
        //End Missing Check In/Out Reservations in Dashboard

        //Schedule Resource Permissions
        $strings['NoResourcePermissions'] = 'U kunt geen details van de reservering zien omdat u geen toestemming heeft voor een of meer bronnen in deze reservering';
        //End Schedule Resource Permissions
        //END NEEDS CHECKING

        $this->Strings = $strings;
    }

    protected function _LoadDays()
    {
        $days = parent::_LoadDays();

        /***
         * DAY NAMES
         * All of these arrays MUST start with Sunday as the first element
         * and go through the seven day week, ending on Saturday
         ***/
        // The full day name
        $days['full'] = ['Zondag', 'Maandag', 'Dinsdag', 'Woensdag', 'Donderdag', 'Vrijdag', 'Zaterdag'];
        // The three letter abbreviation
        $days['abbr'] = ['Zon', 'Maa', 'Din', 'Woe', 'Don', 'Vri', 'Zat'];
        // The two letter abbreviation
        $days['two'] = ['Zo', 'Ma', 'Di', 'Wo', 'Do', 'Vr', 'Za'];
        // The one letter abbreviation
        $days['letter'] = ['Z', 'M', 'D', 'W', 'D', 'V', 'Z'];

        $this->Days = $days;
    }

    protected function _LoadMonths()
    {
        $months = parent::_LoadMonths();

        /***
         * MONTH NAMES
         * All of these arrays MUST start with January as the first element
         * and go through the twelve months of the year, ending on December
         ***/
        // The full month name
        $months['full'] = ['Januari', 'Februari', 'Maart', 'April', 'Mei', 'Juni', 'Juli', 'Augustus', 'September', 'Oktober', 'November', 'December'];
        // The three letter month name
        $months['abbr'] = ['Jan', 'Feb', 'Mrt', 'Apr', 'Mei', 'Jun', 'Jul', 'Aug', 'Sep', 'Okt', 'Nov', 'Dec'];

        $this->Months = $months;
    }

    protected function _LoadLetters()
    {
        $this->Letters = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'];
    }

    protected function _GetHtmlLangCode()
    {
        return 'du_nl';
    }
}
